﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

namespace ApplicationLifeCycle
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            this.textBlock1.Text = "Hello World!";
        }

        protected override void OnNavigatedFrom(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedFrom(e);
            this.State.Remove("id");
            this.State.Add("id", App.id);
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);
            
            if (this.State.ContainsKey("id"))
            {
                if (this.State["id"].Equals(App.id))
                {
                    MessageBox.Show("The Application was dormant" + this.State["id"].ToString());
                }
                else
                {
                    MessageBox.Show("The Application was tombstoned" + this.State["id"].ToString());
                }
            }
            else
            {
                MessageBox.Show("The Application is launched" + App.id.ToString());
            }
        }


    }
}